/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.updater.UpdateChecker;
import net.ftb.util.OSUtils;
import net.ftb.util.SwingUtils;

public class LauncherUpdateDialog
extends JDialog {
    private JLabel messageLbl;
    private JLabel extraText;
    private JLabel updateLbl;
    private JButton showChangeLog;
    private JButton update;
    private JButton abort;
    private boolean usable;

    public LauncherUpdateDialog(final UpdateChecker updateChecker, int deadVersion) {
        super((Frame)LaunchFrame.getInstance(), true);
        this.usable = 10403 > deadVersion;
        this.setupGui();
        this.showChangeLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OSUtils.browse("http://feed-the-beast.com/launcher/change-log/10403");
            }
        });
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LauncherUpdateDialog.this.setVisible(false);
                updateChecker.update();
            }
        });
        this.abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LauncherUpdateDialog.this.setVisible(false);
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("LUNCHERUPDATE_ISAVAILABLETITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.messageLbl = new JLabel(UpdateChecker.UCString + " " + I18N.getLocaleString("LUNCHERUPDATE_ISAVAILABLE"));
        this.extraText = new JLabel(!this.usable ? I18N.getLocaleString("LUNCHERUPDATE_CURRENTDEAD") : "");
        this.extraText.setForeground(Color.red);
        this.updateLbl = new JLabel(I18N.getLocaleString("UPDATE_WICHUPDATE"));
        this.showChangeLog = new JButton(I18N.getLocaleString("LUNCHERUPDATE_CHANGELOG"));
        this.update = new JButton(I18N.getLocaleString("MAIN_YES"));
        this.abort = new JButton(I18N.getLocaleString("MAIN_NO"));
        this.messageLbl.setHorizontalAlignment(0);
        this.updateLbl.setHorizontalAlignment(0);
        panel.add(this.messageLbl);
        panel.add(this.extraText);
        panel.add(this.showChangeLog);
        panel.add(this.updateLbl);
        panel.add(this.update);
        panel.add(this.abort);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.messageLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.extraText, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.updateLbl, hSpring, "West", (Component)panel);
        Spring columnWidth = Spring.width(this.messageLbl);
        columnWidth = Spring.max(columnWidth, Spring.width(this.extraText));
        columnWidth = Spring.max(columnWidth, Spring.width(this.showChangeLog));
        columnWidth = Spring.max(columnWidth, Spring.width(this.updateLbl));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.messageLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.extraText, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.updateLbl, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("HorizontalCenter", (Component)this.showChangeLog, 0, "HorizontalCenter", (Component)panel);
        layout.putConstraint("East", (Component)this.update, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.abort, 5, "HorizontalCenter", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("North", (Component)this.messageLbl, vSpring, "North", (Component)panel);
        vSpring = Spring.sum(vSpring, Spring.height(this.messageLbl));
        vSpring = Spring.sum(vSpring, Spring.constant(10));
        layout.putConstraint("North", (Component)this.extraText, vSpring, "North", (Component)panel);
        vSpring = Spring.sum(vSpring, Spring.height(this.extraText));
        vSpring = Spring.sum(vSpring, Spring.constant(10));
        layout.putConstraint("North", (Component)this.showChangeLog, vSpring, "North", (Component)panel);
        vSpring = Spring.sum(vSpring, Spring.height(this.showChangeLog));
        vSpring = Spring.sum(vSpring, Spring.constant(10));
        layout.putConstraint("North", (Component)this.updateLbl, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.updateLbl), Spring.constant(10));
        layout.putConstraint("North", (Component)this.update, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.abort, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.update), Spring.height(this.abort));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

